/// <binding BeforeBuild='build' ProjectOpened='watch' />

const path = require('path');
const rimraf = require('rimraf');
const browserify = require('browserify');
const gulp = require('gulp');
const gulpLess = require('gulp-less');
const cache = require('gulp-cached');
const cleanCSS = require('gulp-clean-css');
const tap = require('gulp-tap');
const buffer = require('gulp-buffer');
const rename = require('gulp-rename');
const plumber = require('gulp-plumber');
const notify = require('gulp-notify');
const uglify = require('gulp-uglify');
const sourcemaps = require('gulp-sourcemaps');

const CONTENT= 'Content';
const DEST_OPTIONS = { 'mode': 0666 }; // 0666 = new files are created with read and write permissions

var onError = (error) => {
    notify.onError({
        message: '<%= error.message %>'
    })(error);
    this.emit('end');
};

function less() {
    return gulp
        .src(`${CONTENT}/**/*.less`)
        .pipe(cache('less'))
        .pipe(plumber({ errorHandler: onError }))
        .pipe(gulpLess({ paths: [path.join(__dirname, 'less', 'includes')] }))
        .pipe(gulp.dest(CONTENT, DEST_OPTIONS))
        .pipe(cleanCSS({ rebase: false }))
        .pipe(rename({ suffix: '.min' }))
        .pipe(gulp.dest(CONTENT, DEST_OPTIONS));
}

function next() {
    // Delete dist folder.
    rimraf.sync(`${CONTENT}/Next/dist/`);
    // Build js files.
    return gulp.src(`${CONTENT}/Next/src/entries/**/*.js`, { read: false })
        .pipe(
            tap(function (file) {
                const b = browserify(file.path)
                    .transform("babelify")
                    .bundle();
                file.contents = b;
            })
        )
        .pipe(buffer())
        .pipe(sourcemaps.init({ loadMaps: true }))
        .pipe(uglify())
        .pipe(sourcemaps.write('./'))
        .pipe(gulp.dest(`${CONTENT}/Next/dist/`));
}

function watch() {
    gulp.watch(`${CONTENT}/**/*.less`, less);
    gulp.watch(`${CONTENT}/Next/src/**/*.js`, next);
}

exports.build = gulp.parallel(less, next);
exports.watch = watch;